/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWAdminSelectColumnsDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private JLabel m_groupName = null;
    private VWAddRemovePanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private String[] m_availableColumns = null;
    private String[] m_selectedColumns = null;
    private boolean m_bCanceled = true;

    public VWAdminSelectColumnsDialog(Frame parent, Vector availableColumns, Vector selectedColumns) {
        super(parent);
        try {
            if (availableColumns.size() != 0) {
                this.m_availableColumns = new String[availableColumns.size()];
                availableColumns.copyInto(this.m_availableColumns);
            }
            if (selectedColumns.size() != 0) {
                this.m_selectedColumns = new String[selectedColumns.size()];
                selectedColumns.copyInto(this.m_selectedColumns);
            }
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setTitle(VWResource.s_columnSelection);
            this.setVisible(false);
            this.setLocationRelativeTo(parent);
            this.m_addRemovePanel = new VWAddRemovePanel(58);
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableColumns);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedColumns);
            this.m_addRemovePanel.enableSorting(256);
            VWAccessibilityHelper.setLabelFor(this.m_addRemovePanel.getAvailableLabel(), this.m_addRemovePanel.getAvailableJList());
            VWAccessibilityHelper.setLabelFor(this.m_addRemovePanel.getSelectedLabel(), this.m_addRemovePanel.getSelectedJList());
            this.getContentPane().add((Component)this.m_addRemovePanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.addWindowListener(new VWWindowAdapter(this));
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getStatus() {
        return this.m_bCanceled;
    }

    public String[] getSelectedColumns() {
        if (this.m_addRemovePanel != null) {
            return this.m_addRemovePanel.getSelectedStringItems();
        }
        return null;
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (object == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah037.htm");
        }
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = null;
        GridBagConstraints gbCons = null;
        try {
            headerPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            headerPanel.add((Component)new JLabel(""), gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.weightx = 1.0;
            this.m_groupName = new JLabel();
            headerPanel.add((Component)this.m_groupName, gbCons);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void init() {
        this.m_addRemovePanel.initializeLists(this.m_availableColumns, this.m_selectedColumns);
    }

    private boolean isInArray(String itemName, String[] items) {
        if (itemName == null || items == null) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (VWStringUtils.compareIgnoreCase(itemName, items[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

